<?php
/**
 * ------------------------------------------------------------------------
 * JA Filter Plugin - Joom Shopping
 * ------------------------------------------------------------------------
 * Copyright (C) 2004-2016 J.O.O.M Solutions Co., Ltd. All Rights Reserved.
 * @license - GNU/GPL, http://www.gnu.org/licenses/gpl.html
 * Author: J.O.O.M Solutions Co., Ltd
 * Websites: http://www.joomlart.com - http://www.joomlancers.com
 * This file may not be redistributed in whole or significant part.
 * ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;
$params = json_decode($this->item['params']);
?>
{#data}
<div class="item product product-item col">                
	<div data-container="product-grid" class="product-item-info {?thumbnail}{:else} no-image {/thumbnail}">

		<div class="product-item-details">
			{@info:data}
				<div class="row {._class}">
				  {?.key}<div class="col-md-6">{.key}</div>{/.key}
				  <div class="col-md-{?.key}6{:else}12{/.key}">
				  {@select key=._class}
				  	{@eq value="price"}
						<div data-product-id="{id}" data-role="priceBox" class="price-box price-final_price">
							<span class="price-container price-final_price tax weee">
								<span class="price-wrapper " data-price-type="finalPrice" data-price-amount="{price}" id="product-price-{id}">
									<span class="old_price">{frontend_old_price|s}</span>
									<span class="price">{frontend_price|s}</span>    
								</span>
							</span>
						</div>
					{/eq}
				  	{@eq value="name"}
						<h4 class="product-item-name">
							<a href="{url}" class="product-item-link">
								{name|s}
							</a>
						</h4>
					{/eq}
					{@eq value="thumb"}
						{?thumbnail}
						<a tabindex="-1" class="product-item-photo" href="{url}">
							<span class="product-image-container">
								{?label}
								<div class="product_label">
									<img src="<?php echo JUri::root(true)?>{label}" />
								</div>
								{/label}
								<span class="product-image-wrapper">
									<img alt="{name|s}" src="<?php echo JUri::base(true).'/'; ?>{thumbnail}" class="product-image-photo">
								</span>
							</span>
						</a>
						{/thumbnail}
					{/eq}
					{@none}
						{.value|s}
					{/none}
				  {/select}
				  </div>
				</div>
			{/info}
		</div>
		
		<div class="product-item-actions">
			{?is_salable}
			<div class="addtocart-area">
				<form method="post" class="product js-recalculate" action="<?php echo JRoute::_ ('index.php?option=com_jshopping', false); ?>">
					<div class="addtocart-bar">
						<span class="addtocart-button">
							<input name="addtocart" class="btn btn-default" value="<?php echo JText::_('COM_JAMEGAFILTER_ADD_TO_CART'); ?>" title="<?php echo JText::_('COM_JAMEGAFILTER_ADD_TO_CART'); ?>" type="submit">             
						</span>             
						<input name="product_id" value="{id}" type="hidden">
						<input type="hidden" name="controller" value="cart" />
						<input type="hidden" name="task" value="add"/>
					</div> 
					<input type="hidden" name="option" value="com_jshopping"/>
					<input type="hidden" name="category_id" value="{category}" />
				</form>
			</div>
			<div class="view-detail">
				<a class="btn btn-default" href="{url}"><?php echo JText::_('COM_JAMEGAFILTER_VIEW_DETAIL'); ?></a>
			</div>
			{:else}
			<div class="stock unavailable"><span><?php echo JText::_('COM_JAMEGAFILTER_OUT_STOCK'); ?></span></div>
			<div class="view-detail">
				<a class="btn btn-default" href="{url}"><?php echo JText::_('COM_JAMEGAFILTER_VIEW_DETAIL'); ?></a>
			</div>
			{/is_salable}
		</div>
	</div>
</div>
{/data}