<?php
/**
 * ------------------------------------------------------------------------
 * JA Filter Plugin - Joom Shopping
 * ------------------------------------------------------------------------
 * Copyright (C) 2004-2016 J.O.O.M Solutions Co., Ltd. All Rights Reserved.
 * @license - GNU/GPL, http://www.gnu.org/licenses/gpl.html
 * Author: J.O.O.M Solutions Co., Ltd
 * Websites: http://www.joomlart.com - http://www.joomlancers.com
 * This file may not be redistributed in whole or significant part.
 * ------------------------------------------------------------------------
 */

// no direct access
defined('_JEXEC') or die ('Restricted access');
if (!class_exists( 'JSFactory' ) && file_exists(JPATH_ROOT.'/components/com_jshopping/lib/factory.php')) {
	require_once(JPATH_ROOT.'/components/com_jshopping/lib/factory.php');
    $jspConfig = JSFactory::getConfig();
}

// Initiate class to hold plugin events
class plgJamegafilterJshopping extends JPlugin {

	// Some params
	var $pluginName = 'jamegafilterjshopping';
	var $pluginNameHumanReadable = 'JA Megafilter JShopping Plugin';

	function __construct( & $subject, $params) {
		parent::__construct($subject, $params);
	}
	
	function onAfterSaveJshoppingItems($item) {
		require_once (__DIR__.'/helper.php');
		$params = $item->params;
		$helper = new JShoppingFilterHelper($params);
		$objectList = $helper->getFilterItems($params['jajspcat']);
		return $objectList;
	}
	
	function onBeforeDisplayJshoppingItems( $jstemplate, $filter_config, $item )
	{
		$this->jstemplate = $jstemplate;
		$this->config = $filter_config;
		$this->item = $item;
		$input = JFactory::getApplication()->input;
		$jalayout = $input->get('jalayout', 'default');
		$path = JPluginHelper::getLayoutPath('jamegafilter', 'jshopping', $jalayout);
		
		ob_start();
		include $path;
		$output = ob_get_contents();
		ob_end_clean();
		echo $output;
	}
}