<?php
/**
 * ------------------------------------------------------------------------
 * JA Filter Plugin - Joom Shopping
 * ------------------------------------------------------------------------
 * Copyright (C) 2004-2016 J.O.O.M Solutions Co., Ltd. All Rights Reserved.
 * @license - GNU/GPL, http://www.gnu.org/licenses/gpl.html
 * Author: J.O.O.M Solutions Co., Ltd
 * Websites: http://www.joomlart.com - http://www.joomlancers.com
 * This file may not be redistributed in whole or significant part.
 * ------------------------------------------------------------------------
 */
 
defined('_JEXEC') or die;
JLoader::register('BaseFilterHelper', JPATH_ADMINISTRATOR .'/components/com_jamegafilter/base.php');
require_once(JPATH_ADMINISTRATOR . '/components/com_jshopping/models/baseadmin.php');
require_once(JPATH_ADMINISTRATOR . '/components/com_jshopping/models/categories.php');
require_once(JPATH_ADMINISTRATOR . '/components/com_jshopping/models/products.php');
require_once(JPATH_SITE . '/components/com_jshopping/models/productreview.php');

class JShoppingFilterHelper extends BaseFilterHelper {

	function __construct($params = array())
	{
		return parent::__construct($params);
	}

	function getBaseItem($id, $lang) {
		$db = JFactory::getDBO();
		$select = 'SELECT jp.*';
		$from = 'FROM `#__jshopping_products` as jp';

		$where = 'WHERE jp.product_id = ';
		$q = $select . ' ' . $from . ' ' . $where . $id;
		$db->setQuery($q);
		$baseItem = $db->loadObject();
		if (!$baseItem->product_name) {
			$baseItem->product_name = $baseItem->{'name_' . JSFactory::getConfig()->getLang()};
		}
		return $baseItem;
	}

	function getLangSuffix() {
		$langs = JFactory::getLanguage()->getKnownLanguages();
		$lang_sfx = array();
		foreach ($langs as $lang) {
			$lang_sfx[] = $lang['tag'];
		}
		return $lang_sfx;
	}

	function getFilterItems($catid) {
		$filterItems = array();
		$lang_sfx = $this->getLangSuffix();
		foreach ($lang_sfx AS $lang) {
			$filterItems[str_replace('-', '_', strtolower($lang))] = $this->getItemList($catid, $lang);
		}
		
		return $filterItems;
	}

	public function getItemList($catid, $lang) {
		$itemList = new stdCLass();
		$jsModel = new JshoppingModelCategories();
		if ($catid === '0') {
			$childCats = $jsModel->getTreeAllCategories(array(),null,null);
		} else {
			$childCats = $jsModel->getSubCategories($catid);
		}

		$catsList = array(
				$catid
		);
		if (!empty($childCats)) {
			foreach ($childCats AS $k => $child) {
				if ($this->getParentCat($child->category_id,$lang)) {
					if (!$this->isPublished($this->getParentCat($child->category_id, $lang)))
						continue;
				}
				if ($child->category_publish) {
					$catsList[] = $child->category_id;
				}
			}
		}

		$itemIdList = $this->getListId($catsList);
		if (empty($itemIdList)) {
			return array();
		}
		foreach ($itemIdList as $id) {
			$property = 'item_' . $id;
			$item = $this->getItem($id, $lang, $catsList);
			if (!empty($item))
				$itemList->{$property} = $item;
			else
				continue;
		}
		return $itemList;
	}
	
	private function isPublished($catid) {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query -> select('category_publish') ->from('#__jshopping_categories')->where('category_id = '.(int) $catid);
		$db->setQuery($query);
		return $db->loadResult();
	}

	public function getListId($catIds) {
		$db = JFactory::getDbo();
		$select = 'select jpc.product_id';
		$from = ' from #__jshopping_products_to_categories as jpc';
		$join = ' left join #__jshopping_products as jp on jpc.product_id = jp.product_id';
		$where = ' where ( ';
		foreach ($catIds as $key => $id) {
			$where .= $key ? ' or jpc.category_id = ' . $id : 'jpc.category_id = ' . $id;
		}
		$where .= ' ) and jp.product_publish = 1';
		$group = ' group by jpc.product_id order by jpc.product_id desc';
		$q = $select . $from . $join . $where . $group;
		$db->setQuery($q);
		$listID = $db->loadColumn();
		return $listID;
	}

	function getItem($id, $lang, $catsList) {
		$baseItem = $this->getBaseItem($id, $lang);
		$item = new stdClass();
		$item->id = $baseItem->product_id;
		$item->name = $baseItem->{ 'name_'.$lang};
		$item->thumbnail = $this->getThumbnail($baseItem->image);

		// Rating
		$item->rating = (!empty($baseItem->average_rating) ? ($baseItem->average_rating / 2) : 0);
		$jshopConfig = JSFactory::getConfig();
		$rating = round($baseItem->average_rating);
		$item->width_rating = ($rating * 20 / $jshopConfig->rating_starparts);

		$config = JSFactory::getConfig();
		$currency = $config->currency_code;
		$product_currency = $this->getCurrency($baseItem->currency_id);
		$price = $baseItem->product_price / $product_currency->currency_value * $config->currency_value;
		$item->frontend_price = number_format($price, 2) . ' <span class="currency">' . $currency . '</span>';
		$item->price = +$price;

		if ((int)$baseItem->product_old_price) {
			$old_price = $baseItem->product_old_price / $product_currency->currency_value * $config->currency_value;
			$item->frontend_old_price = number_format($old_price, 2) . ' <span class="currency">' . $currency . '</span>';
		}

		if ($baseItem->product_quantity > 0) 
			$item->is_salable = 1;
		$item->label = !empty($baseItem->label_id) ? $this->getLabelImage($baseItem->label_id) : null;

		$item->attr = array();
		if ($this->checkDisplayOnFO('name')) {
			$item->attr['name']['frontend_value'] = $item->name;
			$fieldconfig = $this->getFieldConfig('name');
			$item->attr['name']['title'] = array($fieldconfig['title']);
			$item->attr['name']['type'] = $fieldconfig['type'];
		}

		if ($this->checkDisplayOnFO('price')) {
			$item->attr['price']['frontend_value'] = $item->frontend_price;
			$fieldconfig = $this->getFieldConfig('price');
			$item->attr['price']['title'] = array($fieldconfig['title']);
			$item->attr['price']['type'] = $fieldconfig['type'];
		}

		if ($this->checkDisplayOnFO('rating')) {
			$item->attr['rating']['frontend_value'] = $item->width_rating;
			$fieldconfig = $this->getFieldConfig('rating');
			$item->attr['rating']['title'] = array($fieldconfig['title']);
			$item->attr['rating']['type'] = $fieldconfig['type'];
		}

		if ($baseItem->product_date_added != '0000-00-00 00:00:00') {
			if ($this->checkPublished('created_date')) {
				$item->created_date = array(strtotime($baseItem->product_date_added));
			}

			if ($this->checkDisplayOnFO('created_date')) {
				$item->attr['created_date']['frontend_value'] = array( strtotime($baseItem->product_date_added) );
				$fieldconfig = $this->getFieldConfig('created_date');
				$item->attr['created_date']['title'] = array($fieldconfig['title']);
				$item->attr['created_date']['type'] = $fieldconfig['type'];
			}
		}
		
		if ($baseItem->date_modify != '0000-00-00 00:00:00') {
			if ($this->checkPublished('modified_date')) {
				$item->modified_date = array( strtotime($baseItem->date_modify) );
			}

			if ($this->checkDisplayOnFO('modified_date')) {
				$item->attr['modified_date']['frontend_value'] = array( strtotime($baseItem->date_modify) );
				$fieldconfig = $this->getFieldConfig('modified_date');
				$item->attr['modified_date']['title'] = array($fieldconfig['title']);
				$item->attr['modified_date']['type'] = $fieldconfig['type'];
			}
		}
		
		// special field.
		$this->attr = array();
		$this->getCatInfo($id, $lang, $catsList);
		$this->getManufacturerInfo($id, $lang);
		$this->getAttribuites($id, $lang);
		$this->getCharacteristics($baseItem, $lang);
		$this->getLabels($id, $lang);
		$this->getDeliveryTimes($id, $lang);
		$item->attr = array_merge($item->attr, $this->attr);

		$product_weight = $baseItem->product_weight ? +$baseItem->product_weight : 0;
		if ($this->checkPublished('product_weight')) {
			$item->product_weight = $product_weight;
		}

		if ($this->checkDisplayOnFO('product_weight')) {
			$item->attr['weight']['frontend_value'] =  formatweight($item->product_weight, (int) $baseItem->weight_volume_units);
			$fieldconfig = $this->getFieldConfig('product_weight');
			$item->attr['weight']['title'] = array($fieldconfig['title']);
			$item->attr['weight']['type'] = $fieldconfig['type'];
		}

		$Itemid = $this->getItemid() ? $this->getItemid() : '';
		$item->url = 'index.php?option=com_jshopping&controller=product&task=view&category_id=' . $this->attr['cat']['value'][0] . '&product_id=' . $item->id . '&Itemid=' . (int) $Itemid;
		$item->category = $this->attr['cat']['value'][0];

		return $item;
	}

	function getItemid() {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('id')->from('#__menu')->where('link = "index.php?option=com_jshopping&view=products"');
		$db->setQuery($query);
		$result = $db->loadResult();
		return $result;
	}

	function getThumbnail($image) {
		$path = JPATH_ROOT . '/components/com_jshopping/files/img_products/';
		$path_thumb = 'components/com_jshopping/files/img_products/';
		if (JFile::exists($path . $image)) {
			return $path_thumb . $image;
		} else {
			return $path_thumb . 'noimage.gif';
		}
	}

	function getCatInfo($id, $lang, $catsList) {
		$db = $db = JFactory::getDBO();
		$query = $db->getQuery(true);

		$query = 'SELECT jc.category_id, jc.category_parent_id, jc.`name_'.$lang.'`
				FROM `#__jshopping_products_to_categories` AS jpc
				LEFT JOIN `#__jshopping_categories` AS jc ON jc.category_id = jpc.category_id
				WHERE jc.category_publish = 1 AND jc.category_id IN ('.implode(',', $catsList).') 
				AND product_id = '.$id;
		$db->setQuery($query);
		$cats = $db->loadObjectList();
		if (!$cats) {
			return;
		}
		$cdata = array();
		foreach ($cats as $cat) {
			$cdata['value'][] = $cat->category_id;
			$cdata['frontend_value'][] = $this->getCatNameAsTree($cat, $lang);
		}
		
		$this->attr['cat'] = $cdata;
		
		if ($this->checkDisplayOnFO('attr.cat.value')) {
			$this->attr['cat']['frontend_value'] = $cdata['frontend_value'];
			$fieldconfig = $this->getFieldConfig('attr.cat.value');
			$this->attr['cat']['title'] = array($fieldconfig['title']);
			$this->attr['cat']['type'] = $fieldconfig['type'];
		}
		return $this->attr;
	}

	function getCatNameAsTree($cat, $lang) {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('*')
			->from($db->qn('#__jshopping_categories'))
			->where($db->qn('category_id') . '=' . $db->q($cat->category_parent_id));
		$db->setQuery($query);
		$result = $db->loadObject();
		if ($result) {
			$result->{'name_'.$lang} = $result->{'name_'.$lang} . ' &raquo; ' . $cat->{'name_'.$lang};
			return $this->getCatNameAsTree($result, $lang);
		} else {
			return $cat->{'name_'.$lang};
		}
	}

	function getParentCat($category_id, $lang) {
		$db = JFactory::getDBO();

		$select = 'SELECT jc.category_parent_id';
		$from = 'FROM `#__jshopping_categories` as jc';

		$where = 'WHERE jc.category_id = ';
		$query = $select . ' ' . $from . ' ' . ' ' . $where . (int) $category_id;
		$db->setQuery($query);
		$parentCat = $db->loadResult();
		
		return $parentCat;
	}

	function getManufacturerInfo($id, $lang) {
		$db = JFactory::getDbo();
		$select = 'select jm.manufacturer_id, jm.`name_' . $lang . '`';
		$from = ' from #__jshopping_manufacturers as jm ';
		$join = ' left join #__jshopping_products as jp on jm.manufacturer_id = jp.product_manufacturer_id';

		$where = ' where jp.product_id = ' . (int) $id;
		$where .= ' and jm.manufacturer_publish = 1';
		$query = $select . $from . $join . $where;
		$db->setQuery($query);
		$mfs = $db->loadObjectList();
		if ($mfs) {
			$mdata = array();
			foreach ($mfs as $mf) {
				$mdata['value'][] = $mf->manufacturer_id;
				$mdata['frontend_value'][] = $mf->{'name_' . $lang};
			}
			
			if ($this->checkPublished('attr.manu.value')) {
				$this->attr['manu'] = $mdata;
			}
			if ($this->checkDisplayOnFO('attr.manu.value')) {
				$this->attr['manu']['frontend_value'] = $mdata['frontend_value'];
				$fieldconfig = $this->getFieldConfig('attr.manu.value');
				$this->attr['manu']['title'] = array($fieldconfig['title']);
				$this->attr['manu']['type'] = $fieldconfig['type'];
			}
		}

		return $this->attr;
	}

	function getAttribuites($product_id, $lang) {
		$adata = array();
		$db = JFactory::getDbo();
		
		//get independent attributs
		$query = $db->getQuery(true);
		$query
			->select($db->qn(array('jpa2.attr_id', 'jpa2.attr_value_id', 'jav.name_'.$lang)))
			->from($db->qn('#__jshopping_products_attr2', 'jpa2'))
			->leftJoin($db->qn('#__jshopping_attr_values', 'jav') . 'ON jav.value_id = jpa2.attr_value_id')
			->leftJoin($db->qn('#__jshopping_attr', 'ja') . 'ON ja.attr_id = jpa2.attr_id')
			->where($db->qn('ja.independent') . '= 1')
			->where($db->qn('jpa2.product_id'). '=' . $db->q($product_id));

		$db->setQuery($query);
		$inAttrs = $db->loadObjectList();
		
		foreach ($inAttrs as $ia) {
			$key = 'at'.$ia->attr_id;
			$adata[$key]['value'][] = $ia->attr_value_id;
			$adata[$key]['frontend_value'][] = $ia->{'name_'.$lang};
		}

		//get dependent attributs
		$query->clear()
			->select($db->qn(array('attr_id', 'name_'.$lang )))
			->from($db->qn('#__jshopping_attr'))
			->where($db->qn('independent') . '= 0');

		$db->setQuery($query);
        $deAttrs = $db->loadObjectList();

		foreach ($deAttrs as $da ) {
			$query->clear()
				->select($db->qn(array('jav.value_id', 'jav.name_'.$lang)))
				->from($db->qn('#__jshopping_products_attr', 'jpa'))
				->leftJoin($db->qn('#__jshopping_attr_values', 'jav') . ' ON ' . $db->qn('jav.value_id') . ' = ' .$db->qn('jpa.attr_' . $da->attr_id))
				->where($db->qn('product_id') . '=' . $db->q($product_id))
				->where($db->qn('jpa.attr_' . $da->attr_id) . '> 0')
				->group($db->qn('jpa.attr_' . $da->attr_id));
			
			$db->setQuery($query);
			$proAttrs = $db->loadObjectList();
			foreach ($proAttrs as $pa) {
				$key = 'at'.$da->attr_id;
				$adata[$key]['value'][] = $pa->value_id;
				$adata[$key]['frontend_value'][] = $pa->{'name_'.$lang};
			}
		}

		foreach ($adata as $k => $a) {
			if ($this->checkPublished('attr.'.$k.'.value')) {
				$this->attr[$k] = $a;
			}

			if ($this->checkDisplayOnFO('attr.'.$k.'.value')) {
				$this->attr[$k]['frontend_value'] = $a['frontend_value'];
				$fieldconfig = $this->getFieldConfig('attr.'.$k.'.value');
				$this->attr[$k]['title'] = array($fieldconfig['title']);
				$this->attr[$k]['type'] = $fieldconfig['type'];
			}
		}

		return $this->attr;
	}
	
	function getCharacteristics($baseItem, $lang) {
		$cdata = array();
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('*')
			->from($db->qn('#__jshopping_products_extra_fields'));
		$db->setQuery($query);
		$chars = $db->loadObjectList();
		foreach ($chars as $char) {
			$val = $baseItem->{ 'extra_field_'.$char->id };
			
			if (!$val) {
				continue;
			}
			$key = 'c'.$char->id;
			if ($char->type == 0 && $char->multilist == 0) {
				$query->clear()
					->select($db->qn('name_'.$lang))
					->from($db->qn('#__jshopping_products_extra_field_values'))
					->where($db->qn('field_id') . '=' . $char->id)
					->where($db->qn('id') . '=' . $val);

				$db->setQuery($query);
				$name = $db->loadResult();
				$cdata[$key]['value'][] = $val;
				$cdata[$key]['frontend_value'][] = $name;
			} 
			
			else if ($char->type == 0 && $char->multilist == 1) {
				$query->clear()
					->select($db->qn('name_'.$lang))
					->from($db->qn('#__jshopping_products_extra_field_values'))
					->where($db->qn('field_id') . '=' . $char->id)
					->where($db->qn('id') . ' IN (' . $val . ')');
				$db->setQuery($query);	
				$names = $db->loadColumn();
				
				$cdata[$key]['value'] = explode(',', $val);
				$cdata[$key]['frontend_value'] = $names;
			} 
			
			else if ($char->type == 1) {
				$cdata[$key]['value'][] = urlencode(strtolower($val));
				$cdata[$key]['frontend_value'][] = $val;
			}
		}
		
		foreach ($cdata as $k => $c) {
			if ($this->checkPublished('attr.'.$k.'.value')) {
				$this->attr[$k] = $c;
			}

			if ($this->checkDisplayOnFO('attr.'.$k.'.value')) {
				$this->attr[$k]['frontend_value'] = $c['frontend_value'];
				$fieldconfig = $this->getFieldConfig('attr.'.$k.'.value');
				$this->attr[$k]['title'] = array($fieldconfig['title']);
				$this->attr[$k]['type'] = $fieldconfig['type'];
			}
		}
		
		return $this->attr;
	}

	function getLabels($id, $lang) {
		if ( !$this->checkPublished('attr.lb.value')) return;

		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('jpl.id, jpl.`name_' . $lang . '`')
			->from('#__jshopping_product_labels as jpl')
			->join('LEFT', '#__jshopping_products as jp ON jpl.id = jp.label_id')
			->where('jp.product_id = ' . (int) $id);
		$db->setQuery($query);
		$labels = $db->loadObjectList();
		if (count($labels)) {
			foreach ($labels as $label) {
				$this->attr['lb']['value'][] = $label->id;
				$this->attr['lb']['frontend_value'][] = $label->{'name_' . $lang};
			}
		}

		return $this->attr;
	}

	function getDeliveryTimes($id, $lang) {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('jdt.*')->from('#__jshopping_delivery_times as jdt')
			->join('LEFT', '#__jshopping_products as jp ON jdt.id = jp.delivery_times_id')
			->where('jp.product_id = ' . (int) $id);
		$db->setQuery($query);
		$dts = $db->loadObjectList();
		if (count($dts)) {
			$data = array();
			foreach ($dts as $dt) {
				$data['value'][] = $dt->id;
				$data['frontend_value'][] = ($dt->days <= 1) ? number_format($dt->days, 1) . ' Day' : number_format($dt->days, 1) . ' Days';
			}
			
			if ($this->checkPublished('attr.dt.value')) {
				$this->attr['dt'] = $data;
			}
			
			if ($this->checkDisplayOnFO('attr.dt.value')) {
				$this->attr['dt']['frontend_value'] = $data['frontend_value'];
				$fieldconfig = $this->getFieldConfig('attr.dt.value');
				$this->attr['dt']['title'] = array($fieldconfig['title']);
				$this->attr['dt']['type'] = $fieldconfig['type'];
			}
		}

		return $this->attr;
	}

	function getCurrency($id) {
		$currencies = JSFactory::getAllCurrency();
		foreach ($currencies as $c) {
			if ($c->currency_id == $id ) {
				return $c;
			}
		}
	}

	function getLabelImage($label_id) {
		if (!$this->checkDisplayOnFO('attr.lb.value')) return;

		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('pl.image')->from('#__jshopping_product_labels as pl')->where('pl.id = ' . (int) $label_id);
		$db->setQuery($query);
		$result = $db->loadResult();
		if (!empty($result)) {
			$image = '/components/com_jshopping/files/img_labels/' . $result;
		} else {
			$image = '';
		}
		return $image;
	}

}
