<?php
/**
 * ------------------------------------------------------------------------
 * JA Filter Plugin - Joom Shopping
 * ------------------------------------------------------------------------
 * Copyright (C) 2004-2016 J.O.O.M Solutions Co., Ltd. All Rights Reserved.
 * @license - GNU/GPL, http://www.gnu.org/licenses/gpl.html
 * Author: J.O.O.M Solutions Co., Ltd
 * Websites: http://www.joomlart.com - http://www.joomlancers.com
 * This file may not be redistributed in whole or significant part.
 * ------------------------------------------------------------------------
 */
// No direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport('joomla.form.formfield');

class JFormFieldJaJspCat extends JFormField {

	protected $type = 'JaJspCat';

	protected function getInput() {
		require_once (JPATH_ADMINISTRATOR . '/components/com_jshopping/models/baseadmin.php');
		require_once (JPATH_ADMINISTRATOR . '/components/com_jshopping/models/categories.php');
		$value = 0;
		if (!empty($this->value)) {
			$value = $this->value;
		}

		$catModel = new JshoppingModelCategories();
		$items = $catModel->getTreeAllCategories();

		$html = '';
		$html = '<select name="' . $this->name . '">';
		$html .= '<option value="0">' . JText::_('COM_JAMEGAFILTER_ALL_CATEGORY') . '</option>';
		
		foreach ($items AS $item) {
			if ($item->category_publish == 1) {
				if (($item->category_parent_id && $this->isPublished($item->category_parent_id)) || $item->category_parent_id == 0) {
					if ($item->level > 1) {
						$html .= '<option ' . ($value == $item->category_id ? ' selected="selected" ' : '') . ' value="' . $item->category_id . '">' . str_repeat('&nbsp;&nbsp;', ($item->level - 1)) . '|_.&nbsp;' . $item->name . '</option>';
					} else {
						$html .= '<option ' . ($value == $item->category_id ? ' selected="selected" ' : '') . ' value="' . $item->category_id . '">' . str_repeat('&nbsp;&nbsp;', ($item->level)) . '|_.&nbsp;' . $item->name . '</option>';
					}
				}
			}
		}
		$html .= '</select>';
		return $html;
	}
	
	private function isPublished($catid) {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query -> select('category_publish') ->from('#__jshopping_categories')->where('category_id = '.(int) $catid);
		$db->setQuery($query);
		return $db->loadResult();
	}

}
