<?php
/**
 * ------------------------------------------------------------------------
 * JA Filter Plugin - Joom Shopping
 * ------------------------------------------------------------------------
 * Copyright (C) 2004-2016 J.O.O.M Solutions Co., Ltd. All Rights Reserved.
 * @license - GNU/GPL, http://www.gnu.org/licenses/gpl.html
 * Author: J.O.O.M Solutions Co., Ltd
 * Websites: http://www.joomlart.com - http://www.joomlancers.com
 * This file may not be redistributed in whole or significant part.
 * ------------------------------------------------------------------------
 */
 
// No direct access to this file
defined('_JEXEC') or die('Restricted access');

class JFormFieldFilterfields extends JFormFieldJaMegafilter_filterfields
{
	protected $type = 'filterfields';
	
	function getFieldGroups()
	{
		$class_methods = get_class_methods($this);
		$fl_array	  = preg_grep('/getJaMegafilterField(.*?)/', $class_methods);
		
		$fieldgroups = array();
		foreach ($fl_array as $value) {
			$array_key			   = strtolower(substr($value, 20));
			$fieldgroups[$array_key] = $this->{$value}();
		}
		return $fieldgroups;
	}
	
	function getJaMegafilterFieldBaseField()
	{
		$basefield = array(
			array(
				"published" => 0,
				"sort" => 0,
				"field" => "name",
				"title" => JText::_("COM_JAMEGAFILTER_TITLE"),
				"name" => JText::_("COM_JAMEGAFILTER_TITLE"),
				"filter_type" => array(
					"value"
				)
			),
			
			array(
				"published" => 0,
				"sort" => 0,
				"field" => "price",
				"title" => JText::_("COM_JAMEGAFILTER_PRICE"),
				"name" => JText::_("COM_JAMEGAFILTER_PRICE"),
				"filter_type" => array(
					"range"
				)
			),
			
			array(
				"published" => 0,
				"sort" => 0,
				"field" => "attr.cat.value",
				"title" => JText::_("COM_JAMEGAFILTER_CATEGORY"),
				"name" => JText::_("COM_JAMEGAFILTER_CATEGORY"),
				"filter_type" => array(
					"single",
					"dropdown",
					"multiple"
				)
			),
			
			array(
				"published" => 0,
				"sort" => 0,
				"field" => "attr.manu.value",
				"title" => JText::_("COM_JAMEGAFILTER_MANUFACTURER"),
				"name" => JText::_("COM_JAMEGAFILTER_MANUFACTURER"),
				"filter_type" => array(
					"single",
					"dropdown",
					"multiple"
				)
			),
			
			array(
				"published" => 0,
				"sort" => 0,
				"field" => "rating",
				"title" => JText::_("COM_JAMEGAFILTER_RATING"),
				"name" => JText::_("COM_JAMEGAFILTER_RATING"),
				"filter_type" => array(
					"range"
				)
			),
				
			array(
				"published"=>0,
				"sort" => 0,	
				"field"=> "product_weight",
				"title"=>JText::_("COM_JAMEGAFILTER_WEIGHT"),
				"name"=>JText::_("COM_JAMEGAFILTER_WEIGHT"),
				"filter_type"=>array("range")
			),		
			array(
				"published"=>0,
				"sort" => 0,	
				"field"=> "created_date",
				"title"=>JText::_("COM_JAMEGAFILTER_CREATED_DATE"),
				"name"=>JText::_("COM_JAMEGAFILTER_CREATED_DATE"),
				"filter_type"=>array("date")
			),		
			array(
				"published"=>0,
				"sort" => 0,	
				"field"=> "modified_date",
				"title"=>JText::_("COM_JAMEGAFILTER_MODIFIED_DATE"),
				"name"=>JText::_("COM_JAMEGAFILTER_MODIFIED_DATE"),
				"filter_type"=>array("date")
			),		
	

		);
		return $basefield;
	}
	
	function getJaMegafilterFieldChars() {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query
			->select('*')
			->from($db->qn('#__jshopping_products_extra_fields'));
		$db->setQuery($query);
		$list = $db->loadObjectList();
		$chars = array();
		$lang = JFactory::getLanguage()->getTag();
		foreach ($list as $item) {
			$chars[] = array(
				'published' => 0,
				'sort' => 0,
				'field' => 'attr.c' . $item->id . '.value',
				'title' => $item->{'name_'.$lang},
				'name' => $item->{'name_'.$lang},
				'filter_type' => array('single', 'dropdown', 'multiple', 'color')	
			);
		}
		
		return $chars;
	}
	
	function getJaMegafilterFieldAttrs()
	{
		$Attrs = array();
		
		$db	= JFactory::getDbo()->setQuery($q);
		$query = $db->getQuery(true);
		$query->select('*')->from($db->quoteName('#__jshopping_attr'));
		$db->setQuery($query);
		$fields = $db->loadAssocList();
		if (count($fields)) {
			foreach ($fields as $field) {
				$Attrs[] = array(
					"published" => 0,
					"sort" => 0,
					"field" => 'attr.at' . $field['attr_id'] . '.value',
					"title" => $field['name_en-GB'],
					"name" => $field['name_en-GB'],
					"filter_type" => array(
						"single",
						"dropdown",
						"multiple",
						"color"
					)
				);
			}
		}
		if ($this->getFieldLables()) {
			$Attrs[] = array(
				"published" => 0,
				"sort" => 0,
				"field" => 'attr.lb.value',
				"title" => 'Labels',
				"name" => 'Labels',
				"filter_type" => array(
					"single",
					"dropdown",
					"multiple"
				)
			);
		}
		if ($this->getFieldDeliveryTime()) {
			$Attrs[] = array(
				"published" => 0,
				"sort" => 0,
				"field" => 'attr.dt.value',
				"title" => 'Delivery Times',
				"name" => 'Delivery Times',
				"filter_type" => array(
					"single",
					"dropdown",
					"multiple"
				)
			);
		}
		
		return $Attrs;
	}
	
	function getFieldLables()
	{
		$db	= JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('*')->from('#__jshopping_product_labels');
		$db->setQuery($query);
		$fields = $db->loadAssocList();
		return count($fields);
	}
	
	function getFieldDeliveryTime()
	{
		$db	= JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('*')->from('#__jshopping_delivery_times');
		$db->setQuery($query);
		$fields = $db->loadAssocList();
		return count($fields);
	}
}