<?php
/**
 * @package     Joomla.Site
 * @subpackage  com_content
 *
 * @copyright   Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers');

// T3 ovrride
JHtml::addIncludePath(T3_PATH . '/html/com_content');
JHtml::addIncludePath(dirname(dirname(__FILE__)));

// Create shortcuts to some parameters.
$params  = $this->item->params;
$images  = json_decode($this->item->images);
$urls    = json_decode($this->item->urls);
$canEdit = $params->get('access-edit');
$user    = JFactory::getUser();
$info    = $params->get('info_block_position', 0);

// T3 ovrride.
$aInfo1 = ($params->get('show_publish_date') || $params->get('show_category') || $params->get('show_parent_category') || $params->get('show_author'));
$aInfo2 = ($params->get('show_create_date') || $params->get('show_modify_date') || $params->get('show_hits'));
$topInfo = ($aInfo1 && $info != 1) || ($aInfo2 && $info == 0);
$botInfo = ($aInfo1 && $info == 1) || ($aInfo2 && $info != 0);
$icons = !empty($this->print) || $canEdit || $params->get('show_print_icon') || $params->get('show_email_icon');


// Check if associations are implemented. If they are, define the parameter.
$assocParam = (JLanguageAssociations::isEnabled() && $params->get('show_associations'));
JHtml::_('behavior.caption');

// Template helper
JLoader::register('JATemplateHelper', T3_TEMPLATE_PATH . '/helper.php');

// add color for category
$color = '';
$customs 		= JATemplateHelper::getCustomFields($this->item->catid, 'category');

	if(empty($customs)) :
		$color = "default";
	else: 
		$color = $customs['colors'];
	endif;
// add color end
?>

<div class="item-page<?php echo $this->pageclass_sfx; ?>" itemscope itemtype="https://schema.org/Article">

	<?php if (!empty($this->item->pagination) && $this->item->pagination && !$this->item->paginationposition && $this->item->paginationrelative) {
		echo $this->item->pagination;
	} ?>

	<!-- Article -->
	<article class="<?php echo $color; ?>" itemscope itemtype="http://schema.org/Article">
	  <meta itemscope itemprop="mainEntityOfPage"  itemType="https://schema.org/WebPage" itemid="https://google.com/article"/>
		<meta itemprop="inLanguage" content="<?php echo ($this->item->language === '*') ? JFactory::getConfig()->get('language') : $this->item->language; ?>" />
	  <meta itemprop="description" content="<?php echo strip_tags($this->item->introtext); ?>" />

		<!-- Video - Gallery -->
		<?php
			$attribs = new JRegistry ($this->item->attribs);
			$content_type = $attribs->get('ctm_content_type', 'article'); 
		?>
		<div class="ja-media-content <?php if ($content_type=='video' && $params->get('access-view') ): ?>affix-video<?php endif; ?>">
			<?php if ($content_type=='video' && $params->get('access-view') ): ?>
			<div id="ja-main-player" class="embed-responsive embed-responsive-16by9">
				<span itemscope itemtype="http://schema.org/VideoObject" style="display:none;">
					<span itemprop="name"><?php echo $this->item->title; ?></span>
					<span itemprop="description"><?php echo $this->item->text; ?></span>
					<img itemprop="thumbnailUrl" src="<?php echo JURI::base() ?><?php echo $params->get('ctm_thumbnail'); ?>" alt="<?php echo $this->item->title; ?>"/>
					<meta itemprop="uploadDate" content="<?php echo JHtml::_('date', $this->item->publish_up, 'c'); ?>"/>
				</span>
				<div id="videoplayer">
				  <?php echo JLayoutHelper::render('joomla.content.video_play', array('item' => $this->item, 'context' => 'featured')); ?>
				</div>
			</div>
			
			<?php elseif ($content_type=='gallery' && $params->get('access-view')): ?>
			  <div class="ja-gallery-list-wrap">
			    <?php if (version_compare(JVERSION, '4.0', 'ge')): ?>
					<?php echo JLayoutHelper::render('joomla.content.gallery_play_j4', $this->item); ?>
				<?php else: ?>
					<?php echo JLayoutHelper::render('joomla.content.gallery_play', $this->item); ?>
				<?php endif; ?>
			  </div>
			<?php endif; ?>
		</div>
		<!-- // Video - Gallery -->
		<!-- Image full -->
		<?php	if ($params->get('access-view') && $content_type!='video' & $content_type!='gallery'): ?>
			<?php echo JLayoutHelper::render('joomla.content.fulltext_image', array('item' => $this->item, 'params' => $params)); ?>
		<?php endif; ?>
		<!-- // Image full -->

		<?php if ($params->get('show_title')) : ?>
			<?php echo JLayoutHelper::render('joomla.content.item_title', array('item' => $this->item, 'params' => $params, 'title-tag'=>'h1')); ?>
		<?php endif; ?>
		
		<?php // Content is generated by content plugin event "onContentAfterTitle" ?>
		<?php echo $this->item->event->afterDisplayTitle; ?>

		<?php $useDefList = ($params->get('show_modify_date') || $params->get('show_publish_date') || $params->get('show_create_date')
  	|| $params->get('show_hits') || $params->get('show_category') || $params->get('show_parent_category') || $params->get('show_author') || $assocParam || $icons); ?>

  	<!-- Aside -->
		<?php if ($useDefList && ($info == 0 || $info == 2)) : ?>
		<aside class="article-aside clearfix">
			<?php // Todo: for Joomla4 joomla.content.info_block.block can be changed to joomla.content.info_block ?>
			<?php echo JLayoutHelper::render('joomla.content.info_block.block', array('item' => $this->item, 'params' => $params, 'position' => 'above')); ?>

		  <?php if ($icons): ?>
		  <?php echo JLayoutHelper::render('joomla.content.icons', array('item' => $this->item, 'params' => $params, 'print' => $this->print)); ?>
		  <?php endif; ?>
		</aside>
		<?php endif; ?>
		<!-- // Aside -->

		<?php if (isset ($this->item->toc)) :
			echo $this->item->toc;
		endif; ?>

		<?php // Content is generated by content plugin event "onContentBeforeDisplay" ?>
		<?php echo $this->item->event->beforeDisplayContent; ?>

		<?php if (isset($urls) && ((!empty($urls->urls_position) && ($urls->urls_position == '0')) || ($params->get('urls_position') == '0' && empty($urls->urls_position)))
			|| (empty($urls->urls_position) && (!$params->get('urls_position')))) : ?>
			<?php echo $this->loadTemplate('links'); ?>
		<?php endif; ?>

		<?php if ($params->get('access-view')) : ?>

			<?php if (!empty($this->item->pagination) && $this->item->pagination && !$this->item->paginationposition && !$this->item->paginationrelative) :
				echo $this->item->pagination;
			endif; ?>

			<section class="article-content clearfix" itemprop="articleBody">
				<?php echo $this->item->text; ?>
			</section>

			<!-- Item tags -->
			<?php if ($info == 0 && $params->get('show_tags', 1) && !empty($this->item->tags)) : ?>
				<?php echo JLayoutHelper::render('joomla.content.tags', $this->item->tags->itemTags); ?>
			<?php endif; ?>
			<!-- // Item tags -->

			<!-- Footer -->
			<?php if ($info == 1 || $info == 2) : ?>
				<?php if ($useDefList) : ?>
					<footer class="article-footer clearfix">
					<?php // Todo: for Joomla4 joomla.content.info_block.block can be changed to joomla.content.info_block ?>
					<?php echo JLayoutHelper::render('joomla.content.info_block.block', array('item' => $this->item, 'params' => $params, 'position' => 'below')); ?>
					</footer>
				<?php endif; ?>
			<?php endif; ?>
			<!-- // Footer -->

			<?php if (!empty($this->item->pagination) && $this->item->pagination && $this->item->paginationposition && !$this->item->paginationrelative) :
				echo '<hr class="divider-vertical" />';
				echo $this->item->pagination; ?>
			<?php endif; ?>

			<?php if (isset($urls) && ((!empty($urls->urls_position) && ($urls->urls_position == '1')) || ($params->get('urls_position') == '1'))) : ?>
				<?php echo $this->loadTemplate('links'); ?>
			<?php endif; ?>

			<?php // Optional teaser intro text for guests ?>
			<?php elseif ($params->get('show_noauth') == true && $user->get('guest')) : ?>
				<?php echo JLayoutHelper::render('joomla.content.intro_image', $this->item); ?>
				<?php echo JHtml::_('content.prepare', $this->item->introtext); ?>
				
				<?php // Optional link to let them register to see the whole article. ?>
				<?php if ($params->get('show_readmore') && $this->item->fulltext != null) : ?>
					<?php $menu = JFactory::getApplication()->getMenu(); ?>
					<?php $active = $menu->getActive(); ?>
					<?php $itemId = $active->id; ?>
					<?php $link = new JUri(JRoute::_('index.php?option=com_users&view=login&Itemid=' . $itemId, false)); ?>
					<?php $link->setVar('return', base64_encode(ContentHelperRoute::getArticleRoute($this->item->slug, $this->item->catid, $this->item->language))); ?>

					<section class="readmore">
						<a href="<?php echo $link; ?>" class="register"><span>
						<?php $attribs = json_decode($this->item->attribs); ?>
						<?php
						if ($attribs->alternative_readmore == null) :
							echo JText::_('COM_CONTENT_REGISTER_TO_READ_MORE');
						elseif ($readmore = $attribs->alternative_readmore) :
							echo $readmore;
							if ($params->get('show_readmore_title', 0) != 0) :
								echo JHtml::_('string.truncate', $this->item->title, $params->get('readmore_limit'));
							endif;
						elseif ($params->get('show_readmore_title', 0) == 0) :
							echo JText::sprintf('COM_CONTENT_READ_MORE_TITLE');
						else :
							echo JText::_('COM_CONTENT_READ_MORE');
							echo JHtml::_('string.truncate', $this->item->title, $params->get('readmore_limit'));
						endif; ?>
						</span></a>
					</section>
				<?php endif; ?>
			<?php endif; ?>

	</article>
	<!-- //Article -->

	<?php if (!empty($this->item->pagination) && $this->item->pagination && $this->item->paginationposition && $this->item->paginationrelative) :
		echo $this->item->pagination; ?>
	<?php endif; ?>

	<?php // Content is generated by content plugin event "onContentAfterDisplay" ?>
	<?php echo $this->item->event->afterDisplayContent; ?>
</div>
