<?php
/**
 * ------------------------------------------------------------------------
 * JA Platon Template
 * ------------------------------------------------------------------------
 * Copyright (C) 2004-2011 J.O.O.M Solutions Co., Ltd. All Rights Reserved.
 * @license - Copyrighted Commercial Software
 * Author: J.O.O.M Solutions Co., Ltd
 * Websites:  http://www.joomlart.com -  http://www.joomlancers.com
 * This file may not be redistributed in whole or significant part.
 * ------------------------------------------------------------------------
 */

// no direct access
defined('_JEXEC') or die('Restricted access'); ?>
<!-- Modal -->
<div class="modal fade" id="ja-login-form" tabindex="-1" role="dialog">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="tab-wrapper">
      	<div class="tab-nav-wrapper">
          <ul class="nav nav-tabs clearfix" role="tablist">
            <li class="active" role="presentation" id="ja-user-login-tab"><a href="#ja-user-login" aria-controls="ja-user-login" role="tab" data-toggle="tab"><?php echo JText::_('TXT_LOGIN');?></a></li>

          </ul>
        </div>
        <div class="tab-content clearfix">
	        <!-- LOGIN FORM CONTENT-->
					<div class="tab-pane active" id="ja-user-login">
						<?php if(JPluginHelper::isEnabled('authentication', 'openid')) : ?>
				    	<?php JHTML::_('script', 'openid.js'); ?>
				    <?php endif; ?>
					  <form action="<?php echo JRoute::_('index.php', true, $params->get('usesecure')); ?>" method="post" name="form-login" id="login-form" >
							<div class="pretext">
								<?php echo $params->get('pretext'); ?>
							</div>
							<fieldset class="userdata">
								<p id="form-login-username">
									<label for="modlgn-username"><?php echo JText::_('JAUSERNAME') ?></label>
									<input id="modlgn-username" type="text" name="username" class="inputbox"  size="18" />
								</p>
								<p id="form-login-password">
									<label for="modlgn-passwd"><?php echo JText::_('JGLOBAL_PASSWORD') ?></label>
									<input id="modlgn-passwd" type="password" name="password" class="inputbox" size="18"  />
								</p>
								<?php if (!is_null($tfa) && $tfa != array()):?>
								<p class="login-input secretkey">
									<label class="" for="secretkey" id="secretkey-lbl" aria-invalid="false"><?php echo JText::_('JASECRETKEY') ?></label>
									<input type="text" size="25" value="" id="secretkey" name="secretkey">
								</p>
								<?php endif; ?>
								<?php if (JPluginHelper::isEnabled('system', 'remember')) : ?>
								<p id="form-login-remember">
									<label for="modlgn-remember"><?php echo JText::_('JAREMEMBER_ME') ?></label>
									<input id="modlgn-remember" type="checkbox" name="remember" class="inputbox" value="yes"/>
								</p>
								<?php endif; ?>
							</fieldset>
							<div class="action-button">
								<ul class="list-styled style-3">
									<li>
										<a href="<?php echo JRoute::_('index.php?option=com_users&view=reset'); ?>">
										<?php echo JText::_('FORGOT_YOUR_PASSWORD'); ?></a>
									</li>
									<li>
										<a href="<?php echo JRoute::_('index.php?option=com_users&view=remind'); ?>">
										<?php echo JText::_('FORGOT_YOUR_USERNAME'); ?></a>
									</li>
									<?php
									$usersConfig = JComponentHelper::getParams('com_users');
									if ($usersConfig->get('allowUserRegistration')) : ?>
									<li>
										<a href="<?php echo JRoute::_('index.php?option=com_users&view=registration'); ?>">
											<?php echo JText::_('REGISTER'); ?></a>
									</li>
									<?php endif; ?>
								</ul>
						        <?php echo $params->get('posttext'); ?>
								<button class="btn btn-primary" ><?php echo JText::_('JABUTTON_LOGIN'); ?></button>
						    <button type="button" class="btn btn-inverse" data-dismiss="modal" aria-label="Close"><?php echo JText::_('CLOSE'); ?></button>
								<input type="hidden" name="option" value="com_users" />
								<input type="hidden" name="task" value="user.login" />
								<input type="hidden" name="return" value="<?php echo $return; ?>" />
								<?php echo JHTML::_('form.token'); ?>
							</div>
					    </form>
				    </div>
				    <!-- //LOGIN FORM CONTENT-->
	      
				    
					</div>
      </div>
    </div>
  </div>
</div>
<ul class="ja-login<?php echo $params->get('moduleclass_sfx','')?>">
	<?php if($type == 'logout') : ?>
		<li>
			<form action="<?php echo JRoute::_('index.php', true, $params->get('usesecure')); ?>" method="post" name="form-login" id="login-form">
				<?php if ($params->get('greeting')) : ?>
					<div class="login-greeting">
					<?php if($params->get('name') == 0) :
						echo JText::sprintf('HINAME', $user->get('username'));
					 else :
						echo JText::sprintf('HINAME', $user->get('name'));
					 endif; ?>
					</div>
				<?php endif; ?>
				<div class="logout-button">
					<input type="submit" name="Submit" class="" value="<?php echo JText::_('JLOGOUT'); ?>" />
				</div>

				<input type="hidden" name="option" value="com_users" />
				<input type="hidden" name="task" value="user.logout" />
				<input type="hidden" name="return" value="<?php echo $return; ?>" />
				<?php echo JHTML::_('form.token');?>
			</form>
		</li>
		<?php else : ?>
		<li>
			<a class="login-switch" href="#" data-toggle="modal" data-target="#ja-login-form" title="<?php echo JText::_('TXT_LOGIN');?>">
				<i class="fa fa-sign-in"></i>
				<span class="hidden-xs"><?php echo JText::_('TXT_LOGIN');?></span>
			</a>
		</li>
		<?php
		$option = JRequest::getCmd('option');
		$task = JRequest::getCmd('task');
		if($option!='com_user' && $task != 'register' && $params->get('show_register_form', 1)) 
			{ ?>
		<li>
			<a class="register-switch" href="#" data-toggle="modal" data-target="#ja-login-form" >
				<span class="hidden-xs"><?php echo JText::_('REGISTER');?></span>
				<i class="fa fa-user-plus hidden-sm hidden-md hidden-lg"></i>
			</a>
		</li>
		<?php } ?>
	<?php endif; ?>
</ul>

<script>
(function($){
$(document).ready(function(){
		$('.login-switch').on('click',  function(){
			$('#ja-user-login-tab, #ja-user-register-tab, #ja-user-login, #ja-user-register').removeClass('active');
	    $('#ja-user-login-tab, #ja-user-login').addClass('active');
		});

		$('.register-switch').on('click',  function(){
			$('#ja-user-login-tab, #ja-user-register-tab, #ja-user-login, #ja-user-register').removeClass('active');
	    $('#ja-user-register-tab, #ja-user-register').addClass('active');
		});
	});
})(jQuery);
</script>