<?php
/**
 * ------------------------------------------------------------------------
 * JA BookMark Plugin for J25 & J3x
 * ------------------------------------------------------------------------
 * Copyright (C) 2004-2017 J.O.O.M Solutions Co., Ltd. All Rights Reserved.
 * @license - GNU/GPL, http://www.gnu.org/licenses/gpl.html
 * Author: J.O.O.M Solutions Co., Ltd
 * Websites: http://www.joomlart.com - http://www.joomlancers.com
 * ------------------------------------------------------------------------
 */
 
 defined('JPATH_PLATFORM') or die();
 
 JFormHelper::loadFieldClass('list');
 
 class JFormFieldVMcategory extends JFormFieldList
 {
    /**
    *The form field type.
    * @var  string.
    **/
    
    protected $type = 'VMcategory';
    
    protected function getInput()
    {
        $input = parent::getInput();
        if(!$this->checkComponent('com_virtuemart')){
            $input .= '<br /><span style="color:red">'.JText::_('VirtueMart Component is not installed!').'</span>';
        }
        
        return $input;
    }
    
    protected function getOptions(){
        if(!$this->checkComponent('com_virtuemart')){
            return parent::getOptions();
        }
        
        $db = JFactory::getDbo();
        $options = array();
        $published = $this->element['published'];
        $name = $this->element['category_name'];
        
        $query = $db->getQuery(true)
                ->select('p.*')
                ->from($db->quoteName('#__virtuemart_categories_en_gb','p'))
                ->join('INNER', $db->quoteName('#__virtuemart_categories','c').'ON p.virtuemart_category_id = c.virtuemart_category_id')
                ->where('c.published = 1');
        $db->setQuery($query);
        $citems = $db->loadObjectList();
        
        $sql_parent = $db->getQuery(true)
                    ->select('*')
                    ->from($db->quoteName('#__virtuemart_category_categories'));
        $db->setQuery($sql_parent);
        $parents = $db->loadObjectList();
    
        $children = array();
        
        if($citems){
            foreach($citems as $v){
                foreach($parents as $parent){
                    if($v->virtuemart_category_id == $parent->category_child_id){
                        $v->parent_id = $parent->category_parent_id;
                    }
                    $v->id = $v->virtuemart_category_id;
                    $v->title = $v->category_name;
                }
                $pt = $v->parent_id;
                $list = @$children[$pt] ? $children[$pt] : array();
                array_push($list, $v);
                $children[$pt] = $list;
            }
        }
        $list = JHtml::_('menu.treerecurse', 0, '', array(), $children, 9999, 0, 0);
        $options = array();
        if($list) $options[] = JHtml::_('select.option','', JText::_('ALL_VIRTUEMART_CATEGORIES'));
        foreach($list as $item){
            $item->treename = JString::str_ireplace('&#160;', '- ',$item->treename);
            @$options[] = JHtml::_('select.option', $item->virtuemart_category_id, $item->treename);
        }
        if(isset($this->element['show_root'])){
            array_unshift($options, JHtml::_('select.option', '0', JText::_('JGLOBAL_ROOT')));
        }
        $options = array_merge(parent::getOptions(), $options);
        return $options;   
    }
    
    protected function checkComponent($component){
        $db = JFactory::getDbo();
        $sql = $db->getQuery(true)
            ->select($db->quote('COUNT(*)'))
            ->from($db->quoteName('#__extensions'))
            ->where($db->quoteName('element').'='. $db->quote($component));
        $db->setQuery($sql);
        return $db->loadResult();
    }
 }