<?php
/**
 * ------------------------------------------------------------------------
 * JA Filter Plugin - Content
 * ------------------------------------------------------------------------
 * Copyright (C) 2004-2016 J.O.O.M Solutions Co., Ltd. All Rights Reserved.
 * @license - GNU/GPL, http://www.gnu.org/licenses/gpl.html
 * Author: J.O.O.M Solutions Co., Ltd
 * Websites: http://www.joomlart.com - http://www.joomlancers.com
 * This file may not be redistributed in whole or significant part.
 * ------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

use Joomla\Registry\Registry;
use Joomla\String\StringHelper;
use Joomla\Utilities\ArrayHelper;

class ContentFilterHelper {
	function __construct()
	{
		$this->_db = JFactory::getDbo();
	}
	
	function getLangSuffix()
	{
		$langs = JFactory::getLanguage()->getKnownLanguages();
		$lang_sfx = array();
		foreach ($langs as $lang) {
			$lang_sfx[] = $lang['tag'];
		}
		
		return $lang_sfx;
	}
	
	function getFilterItems($catid)
	{
		$filterItems = array();
		$lang_sfx = $this->getLangSuffix();

		foreach ($lang_sfx AS $lang) {
			$filterItems[strtolower(str_replace('-','_',$lang))] = $this->getItemList($catid,$lang);
		}

		return $filterItems;
	}
	
	public function getItemList($catid, $lang)
	{
		$itemList = new stdCLass();
		if ($catid != '0') {
			$catsList = array($catid);
			foreach ($catsList as $cat) {
				if ($childs = $this->getChildCategories($cat, $lang)) {
					foreach ($childs as $child) {
						$catsList[] = $child;
					}
				}
			}
		} else {
			$catsList = array();
			require_once (JPATH_ADMINISTRATOR . '/components/com_categories/models/categories.php');
			$categoriesModel = new CategoriesModelCategories();
			$categories = $categoriesModel->getItems();
			if ($categories) {
				foreach ($categories as $category) {
					if ($category->published != '1')
						continue;
					if (in_array($category->language, array('*', $lang))) {
						$catsList[] = $category->id;
					}
				}
			}
		}
		
		$itemIdList = $this->getListId($catsList, $lang);
		if ($itemIdList) {
			foreach ($itemIdList as $id) {
				$property = 'item_'.$id;
				$item = $this->getItem($id, $catsList, $lang);
				if( !empty($item))
					$itemList->{ $property } = $item;
				else
					continue;
			}
		} //die();
		
		//echo '<pre>';
		//var_dump($itemList);die();
		
		
		return $itemList;
	}
	
	public function getListId($catids, $lang)
	{
		$query = $this->_db->getQuery(true);
		$query->select('id')
				->from('#__content')
				->where('state = 1 AND catid IN (' .implode(',', $catids) . ') AND language IN ("*", "'.$lang.'")' );
		$this->_db->setQuery($query);
		$listId = $this->_db->loadColumn();

		return $listId;
	}
	
	public function getItem($id, $catsList, $lang)
	{
		$app = JFactory::getApplication();
		$baseItem = $this->getBaseItem($id);
		$images = $baseItem->images;
		
		$item = new stdCLass();
		if (in_array($baseItem->language, array('*', $lang))) {
			$item->id = $id;
			$item->lang = $lang;
			if (!empty($baseItem->hits)) {
				if ((int)$baseItem->hits > 1) {
					$item->hits = (int) $baseItem->hits;
				} else {
					$item->hit = (int) $baseItem->hits;
				}
			} else {
				$item->hit = 0;
			}
			$item->hits = !empty($baseItem->hits) ? (int) $baseItem->hits : 0;
			$item->name = $baseItem->title;
			$item->thumbnail = !empty($images['image_intro']) ? $images['image_intro'] : '';
			$item->desc = !empty($baseItem->introtext) ? $this->getDesc($baseItem->introtext).'...' : '';
			$item->published_date = array(strtotime($baseItem->publish_up));
			//Ratings
			$item->rating = $this->getRating($id) ? $this->getRating($id) : 0;
			$item->width_rating = $item->rating * 20;
			
			
			//Item link
			$item->catid 	= $baseItem->catid;	
			$item->slug        = $baseItem->alias ? ($baseItem->id . ':' . $baseItem->alias) : $baseItem->id;
			$item->catslug     = isset($baseItem->category_alias) ? ($baseItem->catid . ':' . $baseItem->category_alias) : $baseItem->catid;
			
			//Attributes
			$this->attr = array();
			//Category Info
			$this->getCategoryInfo($id, $catsList);
			//Tag Info
			if (!empty($baseItem->tags->tags))
				$this->getTagInfo($baseItem->tags->tags, $lang);
			//Custom fields
			$this->getCustomFieldsInfo($id, $lang);
			//Get All Integer Custom Fields
			$this->getAllIntFields($lang);
			$this->getIntCustomFields($id, $lang);
			
			$item->attr = $this->attr;
		}
		
		return $item;
	}

	public function getDesc($desc) {
		$desc = strip_tags($desc);
		$exp = explode(' ', $desc);
		$result = '';
		foreach ($exp as $key => $value) {
			if ($key > 19) {
				break;
			}
			$result .= $value . ' ';
		}
		return $result;
	}
	
	public function getRating($itemId) 
	{
		$query = $this->_db->getQuery(true);
		$query->select('rating_sum, rating_count')->from('#__content_rating')->where('content_id = '.(int)$itemId);
		$this->_db->setQuery($query);
		$rating = $this->_db->loadObject();
		if (!$rating)
			return false;
		return round((int)$rating->rating_sum / (int) $rating->rating_count, 0);
	}
	
	public function getBaseItem($id)
	{
		require_once (JPATH_ADMINISTRATOR . '/components/com_content/models/article.php');
		JLoader::import('joomla.application.component.model');
		JModelLegacy::addIncludePath(JPATH_BASE . '/components/com_content/models', 'ContentModel');
		$model = JModelLegacy::getInstance('Article', 'ContentModel');
		$baseItem = $model->getItem($id);
		
		return $baseItem;
	}
	
	public function getItemid()
	{
		$query = $this->_db->getQuery(true);
		$query->select('id')
				->from('#__menu')
				->where('`link` REGEXP "^(index.php.*com_docman)(&view=list|tree|document)"');
		$this->_db->setQuery($query);
		
		return $this->_db->loadResult();
	}
	
	
	
	public function getCategoryInfo($itemId, $catsList) {
		if (version_compare(JVERSION, '3.7', '<'))
			return;
		
		$query = $this->_db->getQuery(true);
		$query ->select('c.*')
				->from('#__categories as c')
				->join('LEFT', '#__content as a ON a.catid = c.id')
				->where('a.id = ' . (int) $itemId);
		$this->_db->setQuery($query);
		$category = $this->_db->loadObject();
		
		$this->attr['cat']['value'][] = $category->id;
		$parentTree = array();
		$nameTree = '';
		if ($category->parent_id > 1) {
			$parentTree = $this->getParentTree($category->id);
		}
		if (count($parentTree)) {
			foreach ($parentTree as $p) {
				$nameTree .= $p->name . ' &raquo; ';
			}
			$nameTree .= $category->title;
		} else {
			$nameTree .= $category->title;
		}
		
		
		$this->attr['cat']['frontend_value'][] = $nameTree;
		
		return $this->attr;
	}
	
	public function getCustomFieldsInfo($itemId, $lang) 
	{
		if (version_compare(JVERSION, '3.7', '<'))
			return;
		
		$query = $this->_db->getQuery(true);
		$query->select('f.id, f.title , fv.value, f.type')
				->from('#__fields as f')
				->join('LEFT', '#__fields_values as fv ON fv.field_id = f.id')
				->join('LEFT', '#__content as c ON fv.item_id = c.id')
				->where('c.id = '. (int) $itemId);
		$this->_db->setQuery($query);
		$fields = $this->_db->loadObjectList();
		if ($fields) {
			foreach ($fields as $field) {
				//$field = $fmodel->getItem($fid);
				if (empty($field->value))
					continue;
				switch ($field->type) {
					case 'text':
					case 'editor' :
					case 'textarea' :
					case 'url' :
						if (empty($this->attr['ct'.$field->id]['value']))
							$this->attr['ct'.$field->id]['value'] = '';
						if (empty($this->attr['ct'.$field->id]['frontend_value']))
							$this->attr['ct'.$field->id]['frontend_value'] = '';
						$this->attr['ct'.$field->id]['value'] .= $field->value . ' ';
						$this->attr['ct'.$field->id]['frontend_value'] = $field->value . ' ';
						break;
					case 'calendar' :
						$this->attr['ct'.$field->id]['value'][] = strtotime($field->value);
						$this->attr['ct'.$field->id]['frontend_value'][] = strtotime($field->value);
						break;
					case 'integer' :
						break;
					case 'checkboxes' :
					case 'radio' :
					case 'list' :
					case 'sql' :
						$this->attr['ct'.$field->id]['value'][] = str_replace('+','%20',urlencode($field->value));
						$name = $this->getCustomName($field->id, $field->type, $field->value);
						$this->attr['ct'.$field->id]['frontend_value'][] = $name;
						break;
					case 'usergrouplist' :
						if (!empty($this->getUserGroupName($field->value))) {
							$this->attr['ct'.$field->id]['value'][] = str_replace('+','%20',urlencode($field->value));
							$this->attr['ct'.$field->id]['frontend_value'][] = $this->getUserGroupName($field->value);
						}
						break;
					case 'user' :
							if (JFactory::getUser($field->value)->id) {
								$this->attr['ct'.$field->id]['value'][] = str_replace('+','%20',urlencode($field->value));
								$this->attr['ct'.$field->id]['frontend_value'][] = JFactory::getUser($field->value)->get('name');
							}
						break;
					case 'imagelist' :
						if ($field->value != '-1') {
							$this->attr['ct'.$field->id]['value'][] = str_replace('+','%20',urlencode($field->value));
							$this->attr['ct'.$field->id]['frontend_value'][] = $field->value;
						}
						break;
					default :
						$this->attr['ct'.$field->id]['value'][] = str_replace('+','%20',urlencode($field->value));
						$this->attr['ct'.$field->id]['frontend_value'][] = $field->value;
						break;
				}
			}
		}
		
		return $this->attr;
	}
	
	public function getUserGroupName($groupId)
	{
		$query = $this->_db->getQuery(true);
		$query->select('title')->from('#__usergroups')->where('id = '. (int)$groupId);
		$this->_db->setQuery($query);
		
		return $this->_db->loadResult();
	}
	
	public function getParentTree($catId) {
		$query = $this->_db->getQuery(true);
		$query->select('c1.id as id, c1.title as name, c1.parent_id')
				->from('#__categories as c1')
				->join('LEFT', '#__categories as c2 ON c2.parent_id = c1.id')
				->where('c2.id = '. (int)$catId);
		$this->_db->setQuery($query);
		$parent = $this->_db->loadObject();
		$parents = array($parent);
		if ($parent && $parent->parent_id > 1) {
			array_unshift($parents, $this->getParentTree($parent->id));
		}
		
		return $parents;
	}
	
	public function getTagInfo($tagId, $lang) {
		$query = $this->_db->getQuery(true);
		$query->select('id, title')
				->from('#__tags')
				->where('id IN ('.$tagId. ') AND `language` IN ("*", "'.$lang.'") AND published = 1');
		$this->_db->setQuery($query);
		$tags = $this->_db->loadObjectList();
		
		if ($tags) {
			foreach ($tags as $tag) {
				$this->attr['tag']['value'][] = $tag->id;
				$this->attr['tag']['frontend_value'][] = $tag->title;
			}
		}
		
		return $this->attr;
	}
	
	public function getCustomFields() 
	{
		if (version_compare(JVERSION, '3.7', '<'))
			return;
		
		$query = $this->_db->getQuery(true);
		$query->select('*')->from('#__fields')->where('context = "com_content.article" AND state = 1');
		$this->_db->setQuery($query);
		$fields = $this->_db->loadObjectList();
		
		return $fields;
	}
	
	public function getCustomName($field_id, $field_type, $field_value) 
	{
		$query = $this->_db->getQuery(true);
		$query->select('fieldparams')
				->from('#__fields')
				->where('id = '. (int) $field_id);
		$this->_db->setQuery($query);
		$fparams = $this->_db->loadResult();
		if ($fparams) {
			$registry = new Registry;
			$registry->loadString($fparams);
			$fparams = $registry->toArray();
			switch ($field_type) {
				case 'sql' :
					$q = $fparams['query'];
					if (!empty($q)) {
						$this->_db->setQuery($q);
						$results = $this->_db->loadObjectList();
						if ($results) {
							foreach ($results as $r) {
								if ($r->value == $field_value)
									return $r->text;
							}
						}
					}
					break;
				default :
					if (!empty($fparams['options'])) {
						foreach ($fparams['options'] as $option) {
							if ($option['value'] == $field_value) {
								return $option['name'];
							}
						}
					}
					break;
			}
		}
	}
	
	public function getChildCategories($catid, $lang) 
	{
		$query = $this->_db->getQuery(true);
		$query->select('id')
				->from('#__categories')
				->where('parent_id = '. (int)$catid . ' AND language IN ("*", "'.$lang.'") AND published = 1');
		$this->_db->setQuery($query);
		
		$childrens = $this->_db->loadColumn();
		$catids = array();
		if ($childrens) {
			foreach ($childrens as $child) {
				$catids[] = $child;
				if ($this->getChildCategories($child, $lang)) {
					foreach ($this->getChildCategories($child, $lang) as $c) {
						$catids[] = $c;
					}
				}
			}
		}
		
		return $catids;
	}
	
	public function getIntCustomFields($itemId, $lang)
	{
		if (version_compare(JVERSION, '3.7', '<'))
			return;
		
		$query = $this->_db->getQuery(true);
		$query->select('f.id, fv.value')
				->from('#__fields as f')
				->join('LEFT','#__fields_values as fv ON fv.field_id = f.id')
				->join('LEFT','#__content as c ON c.id = fv.item_id')
				->where('c.id = '.(int) $itemId.' AND f.`type` = "integer" AND f.`language` IN ("*","'.$lang.'") AND f.`state` = 1');
		//echo $query;die();
		$this->_db->setQuery($query);
		$fields = $this->_db->loadObjectList();
		
		if ($fields) {
			foreach ($fields as $f) {
				if (empty($this->attr['ct'.$f->id]['value']))
					$this->attr['ct'.$f->id]['value'] = 0;
				if (empty($this->attr['ct'.$f->id]['frontend_value']))
					$this->attr['ct'.$f->id]['frontend_value'] = 0;
				$this->attr['ct'.$f->id]['value'] += (int)$f->value;
				$this->attr['ct'.$f->id]['frontend_value'] += (int)$f->value;
			}
		}
		
		return $this->attr;
	}
	
	public function getAllIntFields($lang)
	{
		$query = $this->_db->getQuery(true);
		$query->select('id, default_value')->from('#__fields')->where('type = "integer" AND state = 1 AND language IN ("*", "'.$lang.'")');
		$this->_db->setQuery($query);
		$fields = $this->_db->loadObjectList();
		if ($fields) {
			foreach ($fields as $f) {
				$this->attr['ct'.$f->id]['value'] = !empty($f->default_value) ? (int)$f->default_value : 0;
				$this->attr['ct'.$f->id]['frontend_value'] = !empty($f->default_value) ? (int)$f->default_value : 0;
			}
		}
		
		return $this->attr;
	}
}
