<?php
/**
 * @package   T3 Blank
 * @copyright Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license   GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;
$sitename  = $this->params->get('sitename') ? $this->params->get('sitename') : JFactory::getConfig()->get('sitename');
$slogan    = $this->params->get('slogan', '');
$logotype  = $this->params->get('logotype', 'text');
$logoimage = $logotype == 'image' ? $this->params->get('logoimage', T3Path::getUrl('images/logo.png', '', true)) : '';
$logoimgsm = ($logotype == 'image' && $this->params->get('enable_logoimage_sm', 0)) ? $this->params->get('logoimage_sm', T3Path::getUrl('images/logo-sm.png', '', true)) : false;
$hassocial = $this->countModules('followus') || $this->countModules('login') || $this->countModules('head-search');
?>

<!-- MAIN NAVIGATION -->
<nav id="t3-mainnav" class="wrap t3-mainnav navbar-collapse-fixed-top">

	<div class="wrap">
		<?php if($this->countModules("sidenav")) : ?>
		<div class="vert-nav t3-hide">
			<button type="button" class="btn btn-sidenav">
				<i class="icon-reorder"></i>
			</button>

			<div class="side-nav fade <?php echo $this->getParam('navigation_collapse_showsub', 1) ? 'always-show' : '' ?>">
				<?php if ($this->getParam('navigation_type') == 'megamenu') : ?>
					<jdoc:include type="megamenu" name="sidenav" menutype="<?php echo $this->getParam('sidenav_type', 'sidenav') ?>" />
				<?php else : ?>
					<div class="sidenav-wrap <?php $this->_c('sidenav') ?>">
						<jdoc:include type="modules" name="sidenav" style="raw" />
					</div>
				<?php endif ?>
			</div>
		</div>
		<?php endif;?>
		<div class="navbar container">
			<div class="navbar-inner row-fluid">
				<button type="button" class="btn btn-navbar" data-toggle="collapse" data-target=".nav-collapse">
					<i class="icon-reorder"></i>
				</button>

				<!-- LOGO -->
				<div class="span2 item-first spanfirst">
	        <div class="logo-<?php echo $logotype, ($logoimgsm ? ' logo-control' : '') ?>">
	          <div class="brand">
	            <a href="<?php echo JURI::base(true) ?>" title="<?php echo strip_tags($sitename) ?>">
	              <?php if($logotype == 'image'): ?>
	                <img class="logo-img <?php if($logoimgsm) echo 'hidden-phone'; ?>" src="<?php echo JURI::base(true) . '/' . $logoimage ?>" alt="<?php echo strip_tags($sitename) ?>" />
	              <?php endif ?>

	              <?php if($logoimgsm) : ?>
	                <img class="logo-img-sm visible-phone" src="<?php echo JURI::base(true) . '/' . $logoimgsm ?>" alt="<?php echo strip_tags($sitename) ?>" />
	              <?php endif ?>

	              <span><?php echo $sitename ?></span>
	            </a>
	            <small class="site-slogan hidden-phone"><?php echo $slogan ?></small>
	          </div>
	        </div>
				</div>
				<!-- //LOGO -->

				<div class="header-menu <?php echo $hassocial ? 'span6' : 'span10' ?> nav-collapse collapse <?php echo $this->getParam('navigation_collapse_showsub', 1) ? 'always-show' : '' ?>">
					<?php if ($this->getParam('navigation_type') == 'megamenu') : ?>
						<jdoc:include type="megamenu" name="mainnav" menutype="<?php echo $this->getParam('mm_type', 'mainmenu') ?>" />
					<?php else : ?>
						<div class="mainnav-wrap <?php $this->_c('mainnav') ?>">
							<jdoc:include type="modules" name="mainnav" style="raw" />
						</div>
					<?php endif ?>
				</div>
			

				<?php if ($hassocial) : ?>		
					<div class="span4 head-social pull-right">
						<ul class="nav">
							<!-- Language Switcher -->  
							<?php if ($this->countModules('languageswitcherload')) : ?>
								<li id="languageswitcher-block" class="dropdown languageswitcher-block <?php $this->_c('languageswitcherload') ?>">
									<jdoc:include type="modules" name="<?php $this->_p('languageswitcherload') ?>" style="raw" />
								</li>
							<?php endif ?>
							<!-- // Language Switcher -->
							
							<!-- USER, FOLLOW US -->
							<?php if($this->countModules('followus')): ?>
								<li class="dropdown nav-connect">
									<a data-toggle="dropdown" href="#" class=" dropdown-toggle">
										<i class="icon-share"></i>									
									</a>
									<div class="nav-child dropdown-menu">
										<div class="dropdown-menu-inner">
											<jdoc:include type="modules" name="<?php $this->_p('followus') ?>" style="T3Xhtml" />
										</div>
									</div>
								</li>
							<?php endif; ?>
							<!-- //USER, FOLLOW US -->

							<!-- LOGIN -->
							<?php if($this->countModules('login')): ?>
								<?php $user = JFactory::getUser(); ?>
								<li class="dropdown nav-user<?php echo ((!$user->get('guest')) ? ' logged' : ''); ?>">
									<a data-toggle="dropdown" href="#" class=" dropdown-toggle">
										<i class="icon-user"></i>
										<?php echo ((!$user->get('guest')) ? '' : JText::_('')); ?>
									</a>
									<div class="nav-child dropdown-menu">
										<div class="dropdown-menu-inner">
											<jdoc:include type="modules" name="<?php $this->_p('login') ?>" style="T3Xhtml" />
										</div>
									</div>
								</li>
							<?php endif; ?>
							<!-- //LOGIN -->

							<!-- HEAD SEARCH -->
							<?php if ($this->countModules('head-search')) : ?>
								<li class="dropdown nav-search">
									<a data-toggle="dropdown" href="#" class=" dropdown-toggle">
										<i class="icon-search"></i>
									</a>
									<div class="nav-child dropdown-menu">
										<div class="dropdown-menu-inner">
											<jdoc:include type="modules" name="<?php $this->_p('head-search') ?>" style="raw" />
										</div>
									</div>
								</li>
							<?php endif ?>
							<!-- //HEAD SEARCH -->
						</ul>
					</div>
				<?php endif ?>
			</div>
		</div>
	</div>
</nav>
<!-- //MAIN NAVIGATION -->